/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.obj;

import io.github.fabricators_of_create.porting_lib.models.obj.ObjLoader;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjMaterialLibrary;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjModel;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjTokenizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import joptsimple.internal.Strings;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ObjParser {
    public static ObjModel parse(ObjTokenizer tokenizer, ObjModel.ModelSettings settings) throws IOException {
        String[] line;
        if (!ObjModel.ENABLED) {
            throw new IllegalStateException("The Fabric Rendering API is not available. If you have Sodium, install Indium!");
        }
        class_2960 modelLocation = settings.modelLocation();
        String materialLibraryOverrideLocation = settings.mtlOverride();
        ObjModel model = new ObjModel(settings);
        String modelDomain = modelLocation.method_12836();
        String modelPath = modelLocation.method_12832();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        ObjMaterialLibrary mtllib = ObjMaterialLibrary.EMPTY;
        ObjMaterialLibrary.Material currentMat = null;
        String currentSmoothingGroup = null;
        ObjModel.ModelObject currentGroup = null;
        ObjModel.ModelObject currentObject = null;
        ObjModel.ModelMesh currentMesh = null;
        boolean objAboveGroup = false;
        if (materialLibraryOverrideLocation != null) {
            String lib = materialLibraryOverrideLocation;
            mtllib = lib.contains(":") ? ObjLoader.INSTANCE.loadMaterialLibrary(new class_2960(lib)) : ObjLoader.INSTANCE.loadMaterialLibrary(new class_2960(modelDomain, modelPath + lib));
        }
        while ((line = tokenizer.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(new class_2960(lib));
                        break;
                    }
                    mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(new class_2960(modelDomain, modelPath + lib));
                    break;
                }
                case "usemtl": {
                    String mat = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    ObjMaterialLibrary.Material newMat = mtllib.getMaterial(mat);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && currentMesh.mat == null && currentMesh.faces.size() == 0) {
                        currentMesh.mat = currentMat;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    model.positions.add(ObjParser.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    model.texCoords.add(ObjParser.parseVector2(line));
                    break;
                }
                case "vn": {
                    model.normals.add(ObjParser.parseVector3(line));
                    break;
                }
                case "vc": {
                    model.colors.add(ObjParser.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        ObjModel objModel = model;
                        Objects.requireNonNull(objModel);
                        currentMesh = objModel.new ObjModel.ModelMesh(currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            currentObject.meshes.add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                ObjModel objModel2 = model;
                                Objects.requireNonNull(objModel2);
                                currentGroup = objModel2.new ObjModel.ModelGroup("");
                                model.parts.put((Object)"", (Object)currentGroup);
                            }
                            ((ObjModel.ModelGroup)currentGroup).meshes.add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? model.positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? model.texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? model.normals.size() + vertex[2] : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? model.colors.size() + vertex[3] : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    currentMesh.faces.add(vertices);
                    break;
                }
                case "s": {
                    String smoothingGroup;
                    String string = smoothingGroup = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, smoothingGroup)) break;
                    currentSmoothingGroup = smoothingGroup;
                    if (currentMesh != null && currentMesh.smoothingGroup == null && currentMesh.faces.size() == 0) {
                        currentMesh.smoothingGroup = currentSmoothingGroup;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String name = line[1];
                    if (objAboveGroup) {
                        ObjModel objModel = model;
                        Objects.requireNonNull(objModel);
                        currentObject = objModel.new ObjModel.ModelObject(currentGroup.name() + "/" + name);
                        ((ObjModel.ModelGroup)currentGroup).parts.put((Object)name, (Object)currentObject);
                    } else {
                        ObjModel objModel = model;
                        Objects.requireNonNull(objModel);
                        currentGroup = objModel.new ObjModel.ModelGroup(name);
                        model.parts.put((Object)name, (Object)currentGroup);
                        currentObject = null;
                    }
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String name = line[1];
                    if (objAboveGroup || currentGroup == null) {
                        objAboveGroup = true;
                        ObjModel objModel = model;
                        Objects.requireNonNull(objModel);
                        currentGroup = objModel.new ObjModel.ModelGroup(name);
                        model.parts.put((Object)name, (Object)currentGroup);
                        currentObject = null;
                    } else {
                        ObjModel objModel = model;
                        Objects.requireNonNull(objModel);
                        currentObject = objModel.new ObjModel.ModelObject(currentGroup.name() + "/" + name);
                        ((ObjModel.ModelGroup)currentGroup).parts.put((Object)name, (Object)currentObject);
                    }
                    currentMesh = null;
                    break;
                }
            }
        }
        return model;
    }

    public static Vector3f parseVector4To3(String[] line) {
        Vector4f vec4 = ObjParser.parseVector4(line);
        return new Vector3f(vec4.x() / vec4.w(), vec4.y() / vec4.w(), vec4.z() / vec4.w());
    }

    public static class_241 parseVector2(String[] line) {
        return switch (line.length) {
            case 1 -> new class_241(0.0f, 0.0f);
            case 2 -> new class_241(Float.parseFloat(line[1]), 0.0f);
            default -> new class_241(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
        };
    }

    public static Vector3f parseVector3(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector3f();
            case 2 -> new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            case 3 -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            default -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
        };
    }

    public static Vector4f parseVector4(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector4f();
            case 2 -> new Vector4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            case 3 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            case 4 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            default -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
        };
    }
}

